<?php $__env->startSection('content'); ?>
    <div class="pt-3">
        <button data-toggle="modal" data-target="#tambah" type="button" class="btn btn-success">Tambah Banner</button>
    </div>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger mt-3">
            <strong>Ups!</strong> Gagal update.<br><br>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <div class="card mt-3">
        <div class="card-header">
            Banner Promosi
        </div>
        <div class="card-body">
            <table id="table-promosi" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama</th>
                        <th>Deskripsi</th>
                        <th>Batas Waktu</th>
                        <th>Kategori</th>
                        <th>Gambar</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = ($banner_promosi->currentpage() - 1) * $banner_promosi->perpage() + 1; ?>
                    <?php $__currentLoopData = $banner_promosi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td style="width:50px"><?php echo e($i++); ?></td>
                            <td><?php echo e($item->nama); ?></td>
                            <td><?php echo e($item->deskripsi); ?></td>
                            <td><?php echo e($item->batas_waktu); ?></td>
                            <td><?php echo e($item->kategori); ?></td>
                            <td>
                                <img src="<?php echo e(asset('storage/' . $item['gambar'])); ?>" style="max-width:150px" />
                            </td>
                            <td>
                                <?php if($item->status == 1): ?>
                                    <span class="badge badge-success">Aktif</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Off</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($item->status == 1): ?>
                                    <button data-toggle="modal" data-target="#non<?php echo e($item->id); ?>" type="button"
                                        class="btn btn-danger">Non-Aktifkan</button>
                                <?php else: ?>
                                    <button data-toggle="modal" data-target="#aktif<?php echo e($item->id); ?>" type="button"
                                        class="btn btn-primary">Aktifkan</button>
                                <?php endif; ?>
                                <button data-toggle="modal" data-target="#ubah<?php echo e($item->id); ?>" type="button"
                                    class="btn btn-warning">Ubah Data</button>
                                <button data-toggle="modal" data-target="#hapus<?php echo e($item->id); ?>" type="button"
                                    class="btn btn-danger">Hapus</button>
                            </td>
                            <div class="modal-area">
                                <div class="modal fade" id="non<?php echo e($item->id); ?>" tabindex="-1" role="dialog"
                                    aria-labelledby="modaleditstatusnonactive" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <form action="<?php echo e(route('banner_promosi.update', $item->id)); ?>" method="POST">
                                                <?php echo e(csrf_field()); ?>

                                                <?php echo method_field('PUT'); ?>
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="modaleditstatusnonactive">Nonaktifkan Data
                                                    </h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Apakah anda yakin akan menonaktifkan data ?
                                                </div>
                                                <input type="hidden" name="status" value="2">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger">Nonaktifkan</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal fade" id="aktif<?php echo e($item->id); ?>" tabindex="-1" role="dialog"
                                    aria-labelledby="modaleditstatusactive" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <form action="<?php echo e(route('banner_promosi.update', $item->id)); ?>" method="POST">
                                                <?php echo e(csrf_field()); ?>

                                                <?php echo method_field('PUT'); ?>
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="modaleditstatusactive">Aktifkan Data</h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Apakah anda yakin akan mengaktifkan data ?
                                                </div>

                                                <input type="hidden" name="status" value="1">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Aktifkan</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal fade" id="ubah<?php echo e($item->id); ?>" tabindex="-1" role="dialog"
                                    aria-labelledby="modaledit" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <?php if($message = Session::get('error')): ?>
                                                <div class="alert alert-error">
                                                    <p><?php echo e($message); ?></p>
                                                </div>
                                            <?php endif; ?>
                                            <form action="<?php echo e(route('banner_promosi.update', $item->id)); ?>" method="POST"
                                                enctype="multipart/form-data">
                                                <?php echo e(csrf_field()); ?>

                                                <?php echo method_field('PUT'); ?>
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="modaledit">Ubah Data</h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label for="nama">Nama</label>
                                                        <input type="text" class="form-control" name="nama"
                                                            value="<?php echo e($item->nama); ?>" id="nama">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="deskripsi">Deskripsi</label>
                                                        <textarea class="form-control" name="deskripsi" value="<?php echo e($item->deskripsi); ?>" id="deskripsi" rows="5"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="batas_waktu">Batas Waktu</label>
                                                        <input type="datetime-local" class="form-control" name="batas_waktu"
                                                            id="batas_waktu" value="<?php echo e($item->batas_waktu); ?>">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="kategori">Kategori</label>
                                                        <select class="form-control" id="kategori" name="kategori">
                                                            <option>All</option>
                                                            <option value="khusus"
                                                                <?php echo e($item->kategori == 'khusus' ? 'selected' : ''); ?>>Khusus
                                                            </option>
                                                            <option value="sports"
                                                                <?php echo e($item->kategori == 'sports' ? 'selected' : ''); ?>>Sports
                                                            </option>
                                                            <option value="slots"
                                                                <?php echo e($item->kategori == 'slots' ? 'selected' : ''); ?>>Slots
                                                            </option>
                                                            <option value="casino"
                                                                <?php echo e($item->kategori == 'casino' ? 'selected' : ''); ?>>Casino
                                                            </option>
                                                            <option value="others"
                                                                <?php echo e($item->kategori == 'others' ? 'selected' : ''); ?>>Others
                                                            </option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="gambar">Gambar Banner</label>
                                                        <input type="file" class="form-control-file" name="gambar"
                                                            value="<?php echo e($item->gambar); ?>" id="gambar">
                                                        <div class="mt-3">
                                                            <img src="<?php echo e(asset('storage/' . $item['gambar'])); ?>"
                                                                style="max-width:150px" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal fade" id="hapus<?php echo e($item->id); ?>" tabindex="-1" role="dialog"
                                    aria-labelledby="modaledit" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <form action="<?php echo e(route('banner_promosi.update', $item->id)); ?>"
                                                method="POST">
                                                <?php echo e(csrf_field()); ?>

                                                <?php echo method_field('DELETE'); ?>
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="modaleditstatusactive">Hapus</h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Apakah anda yakin akan menghapus data ?
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger">Hapus</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="d-flex flex-row justify-content-center mt-3">
                <?php echo $banner_promosi->links(); ?>

            </div>
        </div>

        <div class="modal fade" id="tambah" tabindex="-1" role="dialog" aria-labelledby="modalBannerBaru"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <form action="<?php echo e(route('banner_promosi.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <?php echo method_field('POST'); ?>
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalBannerBaru">Banner Baru</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="nama">Nama</label>
                                <input type="text" class="form-control" name="nama" value=""
                                    id="nama">
                            </div>
                            <div class="form-group">
                                <label for="deskripsi">Deskripsi</label>
                                <textarea class="form-control" name="deskripsi" value="" id="deskripsi" rows="5"></textarea>
                            </div>
                            <div class="form-group">
                                <label for="batas_waktu">Batas Waktu</label>
                                <input type="datetime-local" class="form-control" name="batas_waktu" id="batas_waktu"
                                    value="">
                            </div>
                            <div class="form-group">
                                <label for="kategori">Kategori</label>
                                <select class="form-control" id="kategori" name="kategori">
                                    <option>All</option>
                                    <option value="khusus">Khusus</option>
                                    <option value="sports">Sports</option>
                                    <option value="slots">Slots</option>
                                    <option value="casino">Casino</option>
                                    <option value="others">Others</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="gambar">Gambar Banner</label>
                                <input type="file" class="form-control-file" name="gambar" value=""
                                    id="gambar">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
         $(document).ready(function() {
            $('#table-promosi').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u118372801/domains/wen3sgay-terbaik.site/public_html/resources/views/backoffice/banner_promosi/banner_promosi.blade.php ENDPATH**/ ?>