<?php $__env->startSection('content'); ?>
    <div class="pt-3">
        <button data-toggle="modal" data-target="#tambah" type="button" class="btn btn-success btn-add"><i class="fa fa-plus"></i> Member Baru</button>
    </div>
    <div class="card mt-3">
        <div class="card-header">
            Data Member
        </div>
        <div class="card-body">
            <?php echo $__env->make('backoffice.layouts.msg_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="table-responsive">
                <table id="example2" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Username</th>
                            <th>Email</th>
                            <th>No Telp</th>
                            <th>Bank</th>
                            <th>Nama Rekening</th>
                            <th>Nomor Rekening</th>
                            <th>Saldo</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data_member; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $saldo = isset($item->saldo[0]) ? $item->saldo[0]->saldo : 0;
                            $bonus = isset($item->saldo[0]) ? $item->saldo[0]->bonus : 0;
                            ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($item->name); ?></td>
                                <td><?php echo e($item->email); ?></td>
                                <td><?php echo e($item->telp); ?></td>
                                <td><?php echo e($item->bank ?? ''); ?></td>
                                <td><?php echo e($item->nama_rek); ?></td>
                                <td><?php echo e($item->no_rek); ?></td>
                                <td><?php echo e(number_format($saldo + $bonus)); ?></td>
                                <td>
                                    <button data-toggle="modal" data-target="#tambah" data-member="<?php echo e(json_encode($item)); ?>" type="button"
                                    class="btn btn-success btn-ubah">Ubah</button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
        </div>
    </div>

    <div class="modal fade" id="tambah" tabindex="-1" role="dialog" aria-labelledby="modalUserBaru"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="<?php echo e(route('data_member.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo e(csrf_field()); ?>

                    <?php echo method_field('POST'); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="modal_member"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input id="id" type="hidden" name="id" value="">
                        <div class="form-group">
                            <label for="judul">Name</label>
                            <input id="nama" type="text" class="form-control" name="nama" value="">
                        </div>
                        <div class="form-group">
                            <label for="judul">Password</label>
                            <input id="password" type="text" class="form-control" name="password" value="">
                        </div>
                        <div class="form-group">
                            <label for="keterangan">Email</label>
                            <input id="email" type="email" class="form-control" name="email" value="">
                        </div>
                        <div class="form-group">
                            <label for="keterangan">Telp</label>
                            <input id="telp" type="text" class="form-control" name="telp" value="">
                        </div>
                        <div class="form-group">
                            <label for="keterangan">Ref Code</label>
                            <input id="ref_code" type="text" class="form-control" name="ref_code" value="">
                        </div>
                        <div class="form-group">
                            <label for="keterangan">Nama Rek</label>
                            <input id="nama_rek" type="text" class="form-control" name="nama_rek" value=""
                                id="keterangan">
                        </div>
                        <div class="form-group">
                            <label for="keterangan">Bank</label>
                            <select id="bank" name="bank" class="form-control">
                            <?php $__currentLoopData = $data_bank; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->nama_bank); ?>"><?php echo e($item->nama_bank); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="keterangan">No Rek</label>
                            <input id="no_rek" type="text" class="form-control" name="no_rek" value=""
                                id="keterangan">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <script>
        $(document).ready(function() {
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });

            $(document).on('click', '.btn-ubah', function(e){
                const data_member = JSON.parse($(this).attr('data-member'));

                $('#modal_member').text('User Ubah');
                $('#id').val(data_member.id);
                $('#nama').val(data_member.name);
                $('#nama').attr('disabled', true);
                $('#email').val(data_member.email);
                $('#telp').val(data_member.telp);
                $('#ref_code').val(data_member.ref_code);
                $('#nama_rek').val(data_member.nama_rek);
                $('#bank').val(data_member.bank);
                $('#no_rek').val(data_member.no_rek);
                
            });

            $(document).on('click', '.btn-add', function(e){

                $('#modal_member').text('User Tambah');
                $('#id').val('');
                $('#nama').val('');
                $('#nama').attr('disabled', false);
                $('#email').val('');
                $('#telp').val('');
                $('#ref_code').val('');
                $('#nama_rek').val('');
                $('#bank').val('');
                $('#no_rek').val('');
            });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backoffice.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp_8\htdocs\fix_two_week\resources\views/backoffice/data_member/data_member.blade.php ENDPATH**/ ?>